function RemArt1DDark(fig,~,~,Energies,EnergyRes,spec,spec2,String,String2)

pos           = get(gca,'CurrentPoint');
E             = EnergyRes*round(pos(1,1)./EnergyRes);

delind        = find(Energies>=E,1,'first');
delind1       = max(1,delind-5);
delind2       = min(size(spec,2),delind+5);
Diff          = spec-spec2;
Deriv         = Diff(1,delind1:delind2) - circshift(Diff(1,delind1:delind2),+1,2) ;
Deriv         = Deriv - circshift(Deriv,-1,2);
Deriv         = Deriv(3:end-2);
[~,Max]       = max(abs(Deriv),[],2);
DelInd        = Max + delind1+1;

%% Plot
figure(fig);
h = findobj(gca,'type','line');
delete(h);
plot(Energies,Diff)
hold on
scatter(Energies(DelInd),Diff(1,DelInd),25,'r','LineWidth',1);
hold off
ylabel( 'Counts [a.u.]' );
xlabel( 'Loss energy [eV]' );
Max = max(abs(Diff));
ylim([-1.5*Max,1.5*Max]);
legend(['Difference ',String,' - ',String2])
xlim([min(Energies),max(Energies)]);
hold off
clearvars all

end